#!/bin/bash
# how to use this script:
# store necessary information in a config.txt file
# use default (recommended) queries stored in a attached files - queryUserList.txt and queryLastLogin.txt
# script loads server address and SID from a config.txt and sends the query loaded from queryUserList to an API interface of the server
# then it parses the mail addresses from the response and cycles query stored in a queryLastLogin.txt to receive last login date for each user
# result is stored in the file results.csv, separated by | (as requested by Rostislav)

# Note: no need to change the query files at all. All you need to do is set 3 variables in a config.txt



# connection properties loaded from config.txt
api_server="https://$(grep -oP '^server="\K[^"]+' config.txt)/icewarpapi/"
SID=$(grep -oP '^SID=\K.*' config.txt)
domain=$(grep -oP '^domain=\K.*' config.txt)

echo server address loaded: $api_server
echo SID loaded: $SID
echo domain loaded: $domain

# Read the XML query from a text file and replace with current SID
query1=$(sed "s/<iq sid=\"[^\"]*\"/<iq sid=\"$SID\"/g; s/<domainstr>[^<]*<\/domainstr>/<domainstr>$domain<\/domainstr>/g" <(cat queryUserList.txt))
echo "http request loaded from queryUserList.txt and parameters has been changed according to settings"
echo "sending to a server"

# Send the XML query to the API server and save the response
response=$(curl -s -X POST -H "Content-Type: application/xml" -d "$query1" "$api_server")

if [[ "$response" == *"session_invalid"* ]]; then
  echo "an error occured, response contains session_invalid string"
  echo "shutting down to avoid any other issues"
  exit 1
fi

#echo $response
echo "response with the list of users received, parsing"
# Extract the email addresses from the response XML and store them in an array
emails=($(echo "$response" | grep -oP '(?<=<email>)[^<]+'))
echo "parsed"
results=()

# Loop through the email addresses and send a second XML query for each one
echo "-----------------"
echo "timestamps are:"

for email in "${emails[@]}"
do
  # Replace SID in query2 using SID variable loaded from config.txt
  query2=$(sed "s/<iq sid=\"[^\"]*\"/<iq sid=\"$SID\"/g" <(cat queryLastLogin.txt))
  # Insert the email address in the correct position in the second XML query
  email_tag="<accountemail>$email<\/accountemail>"
  query2=$(echo "$query2" | sed "s|<accountemail>.*<\/accountemail>|$email_tag|")

  # Send the modified XML query to the API server and save the response
  response2=$(curl -s -X POST -H "Content-Type: application/xml" -d "$query2" "$api_server")
 
  # Extract the timestamp from the response XML and store it in an array
  timestamp=$(echo "$response2" | grep -oP '(?<=<val>)[^<]+')
  timestampHuman=$(date -d @"$timestamp" "+%Y-%m-%d %H:%M:%S")
  echo $email: $timestampHuman
  results+=("$email|$timestampHuman")
done

# Print the results to the console
#for result in "${results[@]}"
#do
#  echo "$result"
#done

# Export the results to a CSV file
printf '%s\n' "${results[@]}" | tr ',' '|'> results.csv
